PACKAGE p_logic_pack IS    
  TYPE t_nine_val IS (Z0, Z1, ZX, 
                      R0, R1, RX, 
                      F0, F1, FX);    

  FUNCTION "AND"( l, r : t_nine_val) RETURN BIT;
    
  FUNCTION "AND"( l : BIT; r : t_nine_val) RETURN BIT;
    
  FUNCTION "AND"( l : t_nine_val; r : BIT) RETURN BIT;
 
END p_logic_pack; 

PACKAGE BODY p_logic_pack IS    
  FUNCTION nine_val_2_bit( t : IN t_nine_val) RETURN BIT IS        
  TYPE t_nine_val_conv IS ARRAY(t_nine_val) OF BIT;        
  CONSTANT nine_2_bit : t_nine_val_conv := 
         ('0',    -- Z0
          '1',    -- Z1
          '1',    -- ZX
          '0',    -- R0
          '1',    -- R1
          '1',    -- RX
          '0',    -- F0
          '1',    -- F1
          '1');   -- FX    
BEGIN
  RETURN nine_2_bit(t);
END nine_val_2_bit;    

  FUNCTION "AND"(l,r : t_nine_val) RETURN BIT IS    
  BEGIN        
    RETURN (nine_val_2_bit(l) AND nine_val_2_bit(r));    
  END;    

  FUNCTION "AND"(l :BIT; r : t_nine_val) RETURN BIT IS    
  BEGIN        
    RETURN ( l AND nine_val_2_bit(r));    
  END;
    
  FUNCTION "AND"(l : t_nine_val; r : BIT) RETURN BIT IS    
  BEGIN        
    RETURN (nine_val_2_bit(l) AND r);    
  END; 
END p_logic_pack;

